/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.proxy;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.twitter.util.FutureEventListener;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.distributedlog.client.ClientConfig;
import org.apache.distributedlog.client.proxy.HostProvider;
import org.apache.distributedlog.client.proxy.ProxyClient;
import org.apache.distributedlog.client.proxy.ProxyListener;
import org.apache.distributedlog.client.stats.ClientStats;
import org.apache.distributedlog.client.stats.OpStats;
import org.apache.distributedlog.thrift.service.ClientInfo;
import org.apache.distributedlog.thrift.service.ServerInfo;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientManager
implements TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ProxyClientManager.class);
    private final ClientConfig clientConfig;
    private final ProxyClient.Builder clientBuilder;
    private final HashedWheelTimer timer;
    private final HostProvider hostProvider;
    private volatile Timeout periodicHandshakeTask;
    private final ConcurrentHashMap<SocketAddress, ProxyClient> address2Services = new ConcurrentHashMap();
    private final CopyOnWriteArraySet<ProxyListener> proxyListeners = new CopyOnWriteArraySet();
    private volatile boolean closed = false;
    private volatile boolean periodicHandshakeEnabled = true;
    private final Stopwatch lastOwnershipSyncStopwatch;
    private final OpStats handshakeStats;

    public ProxyClientManager(ClientConfig clientConfig, ProxyClient.Builder clientBuilder, HashedWheelTimer timer, HostProvider hostProvider, ClientStats clientStats) {
        this.clientConfig = clientConfig;
        this.clientBuilder = clientBuilder;
        this.timer = timer;
        this.hostProvider = hostProvider;
        this.handshakeStats = clientStats.getOpStats("handshake");
        this.scheduleHandshake();
        this.lastOwnershipSyncStopwatch = Stopwatch.createStarted();
    }

    private void scheduleHandshake() {
        if (this.clientConfig.getPeriodicHandshakeIntervalMs() > 0L) {
            this.periodicHandshakeTask = this.timer.newTimeout((TimerTask)this, this.clientConfig.getPeriodicHandshakeIntervalMs(), TimeUnit.MILLISECONDS);
        }
    }

    void setPeriodicHandshakeEnabled(boolean enabled) {
        this.periodicHandshakeEnabled = enabled;
    }

    public void run(Timeout timeout) throws Exception {
        if (timeout.isCancelled() || this.closed) {
            return;
        }
        if (this.periodicHandshakeEnabled) {
            final boolean syncOwnerships = this.lastOwnershipSyncStopwatch.elapsed(TimeUnit.MILLISECONDS) >= this.clientConfig.getPeriodicOwnershipSyncIntervalMs();
            final Set<SocketAddress> hostsSnapshot = this.hostProvider.getHosts();
            final AtomicInteger numHosts = new AtomicInteger(hostsSnapshot.size());
            final AtomicInteger numStreams = new AtomicInteger(0);
            final AtomicInteger numSuccesses = new AtomicInteger(0);
            final AtomicInteger numFailures = new AtomicInteger(0);
            final ConcurrentHashMap streamDistributions = new ConcurrentHashMap();
            final Stopwatch stopwatch = Stopwatch.createStarted();
            Iterator<SocketAddress> iterator = hostsSnapshot.iterator();
            while (iterator.hasNext()) {
                SocketAddress host;
                final SocketAddress address = host = iterator.next();
                final ProxyClient client = this.getClient(address);
                this.handshake(address, client, new FutureEventListener<ServerInfo>(){

                    public void onSuccess(ServerInfo serverInfo) {
                        numStreams.addAndGet(serverInfo.getOwnershipsSize());
                        numSuccesses.incrementAndGet();
                        ProxyClientManager.this.notifyHandshakeSuccess(address, client, serverInfo, false, stopwatch);
                        if (ProxyClientManager.this.clientConfig.isHandshakeTracingEnabled()) {
                            streamDistributions.putIfAbsent(address, serverInfo.getOwnershipsSize());
                        }
                        this.complete();
                    }

                    public void onFailure(Throwable cause) {
                        numFailures.incrementAndGet();
                        ProxyClientManager.this.notifyHandshakeFailure(address, client, cause, stopwatch);
                        this.complete();
                    }

                    private void complete() {
                        if (0 == numHosts.decrementAndGet() && syncOwnerships) {
                            logger.info("Periodic handshaked with {} hosts : {} streams returned, {} hosts succeeded, {} hosts failed", new Object[]{hostsSnapshot.size(), numStreams.get(), numSuccesses.get(), numFailures.get()});
                            if (ProxyClientManager.this.clientConfig.isHandshakeTracingEnabled()) {
                                logger.info("Periodic handshaked stream distribution : {}", (Object)streamDistributions);
                            }
                        }
                    }
                }, false, syncOwnerships);
            }
            if (syncOwnerships) {
                this.lastOwnershipSyncStopwatch.reset().start();
            }
        }
        this.scheduleHandshake();
    }

    public void registerProxyListener(ProxyListener listener) {
        this.proxyListeners.add(listener);
    }

    private void notifyHandshakeSuccess(SocketAddress address, ProxyClient client, ServerInfo serverInfo, boolean logging, Stopwatch stopwatch) {
        if (logging) {
            if (null != serverInfo && serverInfo.isSetOwnerships()) {
                logger.info("Handshaked with {} : {} ownerships returned.", (Object)address, (Object)serverInfo.getOwnerships().size());
            } else {
                logger.info("Handshaked with {} : no ownerships returned", (Object)address);
            }
        }
        this.handshakeStats.completeRequest(address, stopwatch.elapsed(TimeUnit.MICROSECONDS), 1);
        for (ProxyListener listener : this.proxyListeners) {
            listener.onHandshakeSuccess(address, client, serverInfo);
        }
    }

    private void notifyHandshakeFailure(SocketAddress address, ProxyClient client, Throwable cause, Stopwatch stopwatch) {
        this.handshakeStats.failRequest(address, stopwatch.elapsed(TimeUnit.MICROSECONDS), 1);
        for (ProxyListener listener : this.proxyListeners) {
            listener.onHandshakeFailure(address, client, cause);
        }
    }

    public ProxyClient getClient(SocketAddress address) {
        ProxyClient sc = this.address2Services.get(address);
        if (null != sc) {
            return sc;
        }
        return this.createClient(address);
    }

    public void removeClient(SocketAddress address) {
        ProxyClient sc = this.address2Services.remove(address);
        if (null != sc) {
            logger.info("Removed host {}.", (Object)address);
            sc.close();
        }
    }

    public void removeClient(SocketAddress address, ProxyClient sc) {
        if (this.address2Services.remove(address, sc)) {
            logger.info("Remove client {} to host {}.", (Object)sc, (Object)address);
            sc.close();
        }
    }

    public ProxyClient createClient(final SocketAddress address) {
        final ProxyClient sc = this.clientBuilder.build(address);
        ProxyClient oldSC = this.address2Services.putIfAbsent(address, sc);
        if (null != oldSC) {
            sc.close();
            return oldSC;
        }
        final Stopwatch stopwatch = Stopwatch.createStarted();
        FutureEventListener<ServerInfo> listener = new FutureEventListener<ServerInfo>(){

            public void onSuccess(ServerInfo serverInfo) {
                ProxyClientManager.this.notifyHandshakeSuccess(address, sc, serverInfo, true, stopwatch);
            }

            public void onFailure(Throwable cause) {
                ProxyClientManager.this.notifyHandshakeFailure(address, sc, cause, stopwatch);
            }
        };
        this.handshake(address, sc, listener, true, true);
        return sc;
    }

    private void handshake(SocketAddress address, ProxyClient sc, FutureEventListener<ServerInfo> listener, boolean logging, boolean getOwnerships) {
        if (this.clientConfig.getHandshakeWithClientInfo()) {
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.setGetOwnerships(getOwnerships);
            clientInfo.setStreamNameRegex(this.clientConfig.getStreamNameRegex());
            if (logging) {
                logger.info("Handshaking with {} : {}", (Object)address, (Object)clientInfo);
            }
            sc.getService().handshakeWithClientInfo(clientInfo).addEventListener(listener);
        } else {
            if (logging) {
                logger.info("Handshaking with {}", (Object)address);
            }
            sc.getService().handshake().addEventListener(listener);
        }
    }

    public void handshake() {
        Set<SocketAddress> hostsSnapshot = this.hostProvider.getHosts();
        logger.info("Handshaking with {} hosts.", (Object)hostsSnapshot.size());
        final CountDownLatch latch = new CountDownLatch(hostsSnapshot.size());
        final Stopwatch stopwatch = Stopwatch.createStarted();
        Iterator<SocketAddress> iterator = hostsSnapshot.iterator();
        while (iterator.hasNext()) {
            SocketAddress host;
            final SocketAddress address = host = iterator.next();
            final ProxyClient client = this.getClient(address);
            this.handshake(address, client, new FutureEventListener<ServerInfo>(){

                public void onSuccess(ServerInfo serverInfo) {
                    ProxyClientManager.this.notifyHandshakeSuccess(address, client, serverInfo, true, stopwatch);
                    latch.countDown();
                }

                public void onFailure(Throwable cause) {
                    ProxyClientManager.this.notifyHandshakeFailure(address, client, cause, stopwatch);
                    latch.countDown();
                }
            }, true, true);
        }
        try {
            latch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted on handshaking with servers : ", (Throwable)e);
        }
    }

    public int getNumProxies() {
        return this.address2Services.size();
    }

    public Map<SocketAddress, ProxyClient> getAllClients() {
        return ImmutableMap.copyOf(this.address2Services);
    }

    public void close() {
        this.closed = true;
        Timeout task = this.periodicHandshakeTask;
        if (null != task) {
            task.cancel();
        }
        for (ProxyClient sc : this.address2Services.values()) {
            sc.close();
        }
    }
}

