/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.finagle.IndividualRequestTimeoutException;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import com.twitter.util.Promise;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordSetBuffer;
import org.apache.distributedlog.client.speculative.DefaultSpeculativeRequestExecutionPolicy;
import org.apache.distributedlog.client.speculative.SpeculativeRequestExecutionPolicy;
import org.apache.distributedlog.client.speculative.SpeculativeRequestExecutor;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.exceptions.WriteException;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.protocol.util.TwitterFutureUtils;
import org.apache.distributedlog.service.DistributedLogClient;

public class DistributedLogMultiStreamWriter
implements Runnable {
    private final int numStreams;
    private final List<String> streams;
    private final DistributedLogClient client;
    private final int bufferSize;
    private final long requestTimeoutMs;
    private final SpeculativeRequestExecutionPolicy speculativePolicy;
    private final Ticker clockTicker;
    private final CompressionCodec.Type codec;
    private final ScheduledExecutorService scheduler;
    private final boolean ownScheduler;
    private final AtomicInteger nextStreamId;
    private LogRecordSet.Writer recordSetWriter;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DistributedLogMultiStreamWriter(List<String> streams, DistributedLogClient client, int bufferSize, long flushIntervalMicros, long requestTimeoutMs, int firstSpecultiveTimeoutMs, int maxSpeculativeTimeoutMs, float speculativeBackoffMultiplier, CompressionCodec.Type codec, Ticker clockTicker, ScheduledExecutorService scheduler) {
        this.streams = Lists.newArrayList(streams);
        this.numStreams = this.streams.size();
        this.client = client;
        this.bufferSize = bufferSize;
        this.requestTimeoutMs = requestTimeoutMs;
        this.codec = codec;
        this.clockTicker = clockTicker;
        if (null == scheduler) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MultiStreamWriterFlushThread-%d").build());
            this.ownScheduler = true;
        } else {
            this.scheduler = scheduler;
            this.ownScheduler = false;
        }
        this.speculativePolicy = new DefaultSpeculativeRequestExecutionPolicy(firstSpecultiveTimeoutMs, maxSpeculativeTimeoutMs, speculativeBackoffMultiplier);
        Collections.shuffle(this.streams);
        this.nextStreamId = new AtomicInteger(0);
        this.recordSetWriter = this.newRecordSetWriter();
        if (flushIntervalMicros > 0L) {
            this.scheduler.scheduleAtFixedRate(this, flushIntervalMicros, flushIntervalMicros, TimeUnit.MICROSECONDS);
        }
    }

    String getStream(int streamId) {
        return this.streams.get(streamId);
    }

    synchronized LogRecordSet.Writer getLogRecordSetWriter() {
        return this.recordSetWriter;
    }

    private LogRecordSet.Writer newRecordSetWriter() {
        return LogRecordSet.newWriter((int)this.bufferSize, (CompressionCodec.Type)this.codec);
    }

    public synchronized Future<DLSN> write(ByteBuffer buffer) {
        int logRecordSize = buffer.remaining();
        if (logRecordSize > 1040384) {
            return Future.exception((Throwable)new LogRecordTooLongException("Log record of size " + logRecordSize + " written when only " + 1040384 + " is allowed"));
        }
        if (this.recordSetWriter.getNumBytes() + logRecordSize > 1044480) {
            this.flush();
        }
        Promise writePromise = new Promise();
        try {
            this.recordSetWriter.writeRecord(buffer, TwitterFutureUtils.newJFuture((Promise)writePromise));
        }
        catch (LogRecordTooLongException e) {
            return Future.exception((Throwable)e);
        }
        catch (WriteException e) {
            this.recordSetWriter.abortTransmit((Throwable)e);
            this.recordSetWriter = this.newRecordSetWriter();
            return Future.exception((Throwable)e);
        }
        if (this.recordSetWriter.getNumBytes() >= this.bufferSize) {
            this.flush();
        }
        return writePromise;
    }

    @Override
    public void run() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        LogRecordSet.Writer recordSetToFlush;
        DistributedLogMultiStreamWriter distributedLogMultiStreamWriter = this;
        synchronized (distributedLogMultiStreamWriter) {
            if (this.recordSetWriter.getNumRecords() == 0) {
                return;
            }
            recordSetToFlush = this.recordSetWriter;
            this.recordSetWriter = this.newRecordSetWriter();
        }
        this.transmit(recordSetToFlush);
    }

    private void transmit(LogRecordSet.Writer recordSetToFlush) {
        PendingWriteRequest writeRequest = new PendingWriteRequest((LogRecordSetBuffer)recordSetToFlush);
        this.speculativePolicy.initiateSpeculativeRequest(this.scheduler, writeRequest);
    }

    public void close() {
        if (this.ownScheduler) {
            this.scheduler.shutdown();
        }
    }

    static /* synthetic */ Ticker access$200(DistributedLogMultiStreamWriter x0) {
        return x0.clockTicker;
    }

    class PendingWriteRequest
    implements FutureEventListener<DLSN>,
    SpeculativeRequestExecutor {
        private final LogRecordSetBuffer recordSet;
        private AtomicBoolean complete = new AtomicBoolean(false);
        private final Stopwatch stopwatch = Stopwatch.createStarted((Ticker)DistributedLogMultiStreamWriter.access$200(DistributedLogMultiStreamWriter.this));
        private int nextStream;
        private int numTriedStreams = 0;

        PendingWriteRequest(LogRecordSetBuffer recordSet) {
            this.recordSet = recordSet;
            this.nextStream = Math.abs(DistributedLogMultiStreamWriter.this.nextStreamId.incrementAndGet()) % DistributedLogMultiStreamWriter.this.numStreams;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized String sendNextWrite() {
            long elapsedMs = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsedMs > DistributedLogMultiStreamWriter.this.requestTimeoutMs || this.numTriedStreams >= DistributedLogMultiStreamWriter.this.numStreams) {
                this.fail((Throwable)new IndividualRequestTimeoutException(Duration.fromMilliseconds((long)elapsedMs)));
                return null;
            }
            try {
                String string = this.sendWriteToStream(this.nextStream);
                return string;
            }
            finally {
                this.nextStream = (this.nextStream + 1) % DistributedLogMultiStreamWriter.this.numStreams;
                ++this.numTriedStreams;
            }
        }

        synchronized String sendWriteToStream(int streamId) {
            String stream = DistributedLogMultiStreamWriter.this.getStream(streamId);
            DistributedLogMultiStreamWriter.this.client.writeRecordSet(stream, this.recordSet).addEventListener((FutureEventListener)this);
            return stream;
        }

        public void onSuccess(DLSN dlsn) {
            if (!this.complete.compareAndSet(false, true)) {
                return;
            }
            this.recordSet.completeTransmit(dlsn.getLogSegmentSequenceNo(), dlsn.getEntryId(), dlsn.getSlotId());
        }

        public void onFailure(Throwable cause) {
            this.sendNextWrite();
        }

        private void fail(Throwable cause) {
            if (!this.complete.compareAndSet(false, true)) {
                return;
            }
            this.recordSet.abortTransmit(cause);
        }

        @Override
        public Future<Boolean> issueSpeculativeRequest() {
            return Future.value((Object)(!this.complete.get() && null != this.sendNextWrite() ? 1 : 0));
        }
    }

    public static class Builder {
        private DistributedLogClient client = null;
        private List<String> streams = null;
        private int bufferSize = 16384;
        private long flushIntervalMicros = 2000L;
        private CompressionCodec.Type codec = CompressionCodec.Type.NONE;
        private ScheduledExecutorService executorService = null;
        private long requestTimeoutMs = 500L;
        private int firstSpeculativeTimeoutMs = 50;
        private int maxSpeculativeTimeoutMs = 200;
        private float speculativeBackoffMultiplier = 2.0f;
        private Ticker ticker = Ticker.systemTicker();

        private Builder() {
        }

        public Builder client(DistributedLogClient client) {
            this.client = client;
            return this;
        }

        public Builder streams(List<String> streams) {
            this.streams = streams;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder flushIntervalMs(int flushIntervalMs) {
            this.flushIntervalMicros = TimeUnit.MILLISECONDS.toMicros(flushIntervalMs);
            return this;
        }

        public Builder flushIntervalMicros(int flushIntervalMicros) {
            this.flushIntervalMicros = flushIntervalMicros;
            return this;
        }

        public Builder compressionCodec(CompressionCodec.Type codec) {
            this.codec = codec;
            return this;
        }

        public Builder scheduler(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder requestTimeoutMs(long requestTimeoutMs) {
            this.requestTimeoutMs = requestTimeoutMs;
            return this;
        }

        public Builder firstSpeculativeTimeoutMs(int timeoutMs) {
            this.firstSpeculativeTimeoutMs = timeoutMs;
            return this;
        }

        public Builder maxSpeculativeTimeoutMs(int timeoutMs) {
            this.maxSpeculativeTimeoutMs = timeoutMs;
            return this;
        }

        public Builder speculativeBackoffMultiplier(float multiplier) {
            this.speculativeBackoffMultiplier = multiplier;
            return this;
        }

        public Builder clockTicker(Ticker ticker) {
            this.ticker = ticker;
            return this;
        }

        public DistributedLogMultiStreamWriter build() {
            Preconditions.checkArgument((null != this.streams && !this.streams.isEmpty() ? 1 : 0) != 0, (Object)"No streams provided");
            Preconditions.checkNotNull((Object)this.client, (Object)"No distributedlog client provided");
            Preconditions.checkNotNull((Object)this.codec, (Object)"No compression codec provided");
            Preconditions.checkArgument((this.firstSpeculativeTimeoutMs > 0 && this.firstSpeculativeTimeoutMs <= this.maxSpeculativeTimeoutMs && this.speculativeBackoffMultiplier > 0.0f && (long)this.maxSpeculativeTimeoutMs < this.requestTimeoutMs ? 1 : 0) != 0, (Object)"Invalid speculative timeout settings");
            return new DistributedLogMultiStreamWriter(this.streams, this.client, Math.min(this.bufferSize, 1044480), this.flushIntervalMicros, this.requestTimeoutMs, this.firstSpeculativeTimeoutMs, this.maxSpeculativeTimeoutMs, this.speculativeBackoffMultiplier, this.codec, this.ticker, this.executorService);
        }
    }
}

