/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.lang.model.util.Types;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class ClassUseMapper {
    private final ClassTree classtree;
    public final Map<TypeElement, Set<PackageElement>> classToPackage;
    public final Map<TypeElement, List<PackageElement>> classToPackageAnnotations = new HashMap<TypeElement, List<PackageElement>>();
    public final Map<TypeElement, Set<TypeElement>> classToClass = new HashMap<TypeElement, Set<TypeElement>>();
    public final Map<TypeElement, List<TypeElement>> classToSubclass = new HashMap<TypeElement, List<TypeElement>>();
    public final Map<TypeElement, List<TypeElement>> classToSubinterface = new HashMap<TypeElement, List<TypeElement>>();
    public Map<TypeElement, List<TypeElement>> classToImplementingClass = new HashMap<TypeElement, List<TypeElement>>();
    public final Map<TypeElement, List<VariableElement>> classToField = new HashMap<TypeElement, List<VariableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodReturn = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodArgs = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodThrows = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToConstructorArgs = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToConstructorThrows = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToConstructorAnnotations = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToConstructorParamAnnotation = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToConstructorArgTypeParam = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<TypeElement>> classToClassTypeParam = new HashMap<TypeElement, List<TypeElement>>();
    public final Map<TypeElement, List<TypeElement>> classToClassAnnotations = new HashMap<TypeElement, List<TypeElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodTypeParam = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodArgTypeParam = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodAnnotations = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodReturnTypeParam = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<ExecutableElement>> classToMethodParamAnnotation = new HashMap<TypeElement, List<ExecutableElement>>();
    public final Map<TypeElement, List<VariableElement>> classToFieldTypeParam = new HashMap<TypeElement, List<VariableElement>>();
    public final Map<TypeElement, List<VariableElement>> annotationToField = new HashMap<TypeElement, List<VariableElement>>();
    private final DocletEnvironment root;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final Utils utils;

    public ClassUseMapper(ConfigurationImpl configuration, ClassTree classtree) {
        this.root = configuration.root;
        this.elementUtils = this.root.getElementUtils();
        this.typeUtils = this.root.getTypeUtils();
        this.utils = configuration.utils;
        this.classtree = classtree;
        this.classToPackage = new TreeMap<Element, Set<PackageElement>>(this.utils.makeClassUseComparator());
        for (TypeElement te : classtree.baseClasses()) {
            this.subclasses(te);
        }
        for (TypeElement intfc : classtree.baseInterfaces()) {
            this.implementingClasses(intfc);
        }
        Set<TypeElement> classes = this.root.getIncludedClasses();
        for (TypeElement aClass : classes) {
            PackageElement pkg = this.elementUtils.getPackageOf(aClass);
            this.mapAnnotations(this.classToPackageAnnotations, pkg, pkg);
            this.mapTypeParameters(this.classToClassTypeParam, aClass, aClass);
            this.mapAnnotations(this.classToClassAnnotations, aClass, aClass);
            List<VariableElement> fields = this.utils.getFields(aClass);
            for (VariableElement variableElement : fields) {
                this.mapTypeParameters(this.classToFieldTypeParam, variableElement, variableElement);
                this.mapAnnotations(this.annotationToField, variableElement, variableElement);
                SimpleTypeVisitor9<Void, VariableElement> stv = new SimpleTypeVisitor9<Void, VariableElement>(){

                    @Override
                    public Void visitArray(ArrayType t, VariableElement p) {
                        return (Void)this.visit(t.getComponentType(), p);
                    }

                    @Override
                    public Void visitDeclared(DeclaredType t, VariableElement p) {
                        ClassUseMapper.this.add(ClassUseMapper.this.classToField, (TypeElement)t.asElement(), p);
                        return null;
                    }

                    @Override
                    public Void visitTypeVariable(TypeVariable t, VariableElement p) {
                        return (Void)this.visit(ClassUseMapper.this.typeUtils.erasure(t), p);
                    }
                };
                stv.visit(variableElement.asType(), variableElement);
            }
            List<ExecutableElement> ctors = this.utils.getConstructors(aClass);
            for (ExecutableElement ctor : ctors) {
                this.mapAnnotations(this.classToConstructorAnnotations, ctor, ctor);
                this.mapExecutable(ctor);
            }
            List<ExecutableElement> list = this.utils.getMethods(aClass);
            for (ExecutableElement method : list) {
                this.mapExecutable(method);
                this.mapTypeParameters(this.classToMethodTypeParam, method, method);
                this.mapAnnotations(this.classToMethodAnnotations, method, method);
                SimpleTypeVisitor9<Void, ExecutableElement> stv = new SimpleTypeVisitor9<Void, ExecutableElement>(){

                    @Override
                    public Void visitArray(ArrayType t, ExecutableElement p) {
                        TypeMirror componentType = t.getComponentType();
                        return (Void)this.visit(ClassUseMapper.this.utils.isTypeVariable(componentType) ? ClassUseMapper.this.typeUtils.erasure(componentType) : componentType, p);
                    }

                    @Override
                    public Void visitDeclared(DeclaredType t, ExecutableElement p) {
                        ClassUseMapper.this.mapTypeParameters(ClassUseMapper.this.classToMethodReturnTypeParam, t, p);
                        ClassUseMapper.this.add(ClassUseMapper.this.classToMethodReturn, (TypeElement)t.asElement(), p);
                        return null;
                    }

                    @Override
                    protected Void defaultAction(TypeMirror e, ExecutableElement p) {
                        return null;
                    }
                };
                stv.visit(method.getReturnType(), method);
            }
        }
    }

    private Collection<TypeElement> subclasses(TypeElement te) {
        TreeSet<Element> ret = (TreeSet<Element>)((Object)this.classToSubclass.get(te));
        if (ret == null) {
            ret = new TreeSet<Element>(this.utils.makeClassUseComparator());
            SortedSet<TypeElement> subs = this.classtree.subClasses(te);
            if (subs != null) {
                ret.addAll(subs);
                for (TypeElement sub : subs) {
                    ret.addAll(this.subclasses(sub));
                }
            }
            this.addAll(this.classToSubclass, te, ret);
        }
        return ret;
    }

    private Collection<TypeElement> subinterfaces(TypeElement te) {
        TreeSet<Element> ret = (TreeSet<Element>)((Object)this.classToSubinterface.get(te));
        if (ret == null) {
            ret = new TreeSet<Element>(this.utils.makeClassUseComparator());
            SortedSet<TypeElement> subs = this.classtree.subInterfaces(te);
            if (subs != null) {
                ret.addAll(subs);
                for (TypeElement sub : subs) {
                    ret.addAll(this.subinterfaces(sub));
                }
            }
            this.addAll(this.classToSubinterface, te, ret);
        }
        return ret;
    }

    private Collection<TypeElement> implementingClasses(TypeElement te) {
        TreeSet<Element> ret = (TreeSet<Element>)((Object)this.classToImplementingClass.get(te));
        if (ret == null) {
            ret = new TreeSet<Element>(this.utils.makeClassUseComparator());
            SortedSet<TypeElement> impl = this.classtree.implementingClasses(te);
            if (impl != null) {
                ret.addAll(impl);
                for (TypeElement anImpl : impl) {
                    ret.addAll(this.subclasses(anImpl));
                }
            }
            for (TypeElement intfc : this.subinterfaces(te)) {
                ret.addAll(this.implementingClasses(intfc));
            }
            this.addAll(this.classToImplementingClass, te, ret);
        }
        return ret;
    }

    private void mapExecutable(ExecutableElement ee) {
        final boolean isConstructor = this.utils.isConstructor(ee);
        TreeSet<TypeMirror> classArgs = new TreeSet<TypeMirror>(this.utils.makeTypeMirrorClassUseComparator());
        for (VariableElement variableElement : ee.getParameters()) {
            TypeMirror pType = variableElement.asType();
            if (!pType.getKind().isPrimitive() && !this.utils.isTypeVariable(pType) && classArgs.add(pType)) {
                new SimpleTypeVisitor9<Void, ExecutableElement>(){

                    @Override
                    public Void visitArray(ArrayType t, ExecutableElement p) {
                        return (Void)this.visit(t.getComponentType(), p);
                    }

                    @Override
                    public Void visitDeclared(DeclaredType t, ExecutableElement p) {
                        ClassUseMapper.this.add(isConstructor ? ClassUseMapper.this.classToConstructorArgs : ClassUseMapper.this.classToMethodArgs, (TypeElement)t.asElement(), p);
                        return null;
                    }

                    @Override
                    public Void visitTypeVariable(TypeVariable t, ExecutableElement p) {
                        this.visit(ClassUseMapper.this.typeUtils.erasure(t), p);
                        return null;
                    }
                }.visit(pType, ee);
                this.mapTypeParameters(isConstructor ? this.classToConstructorArgTypeParam : this.classToMethodArgTypeParam, pType, ee);
            }
            this.mapAnnotations(isConstructor ? this.classToConstructorParamAnnotation : this.classToMethodParamAnnotation, variableElement, ee);
        }
        for (TypeMirror typeMirror : ee.getThrownTypes()) {
            SimpleTypeVisitor9<Void, ExecutableElement> stv = new SimpleTypeVisitor9<Void, ExecutableElement>(){

                @Override
                public Void visitArray(ArrayType t, ExecutableElement p) {
                    super.visit(t.getComponentType(), p);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, ExecutableElement p) {
                    ClassUseMapper.this.add(isConstructor ? ClassUseMapper.this.classToConstructorThrows : ClassUseMapper.this.classToMethodThrows, (TypeElement)t.asElement(), p);
                    return null;
                }

                @Override
                public Void visitError(ErrorType t, ExecutableElement p) {
                    ClassUseMapper.this.add(isConstructor ? ClassUseMapper.this.classToConstructorThrows : ClassUseMapper.this.classToMethodThrows, (TypeElement)t.asElement(), p);
                    return null;
                }

                @Override
                protected Void defaultAction(TypeMirror e, ExecutableElement p) {
                    throw new AssertionError((Object)"this should not happen");
                }
            };
            stv.visit(this.typeUtils.erasure(typeMirror), ee);
        }
    }

    private <T> List<T> refList(Map<TypeElement, List<T>> map, Element element) {
        List<T> list = map.get(element);
        if (list == null) {
            list = new ArrayList<T>();
            map.put((TypeElement)element, list);
        }
        return list;
    }

    private Set<PackageElement> packageSet(TypeElement te) {
        Set<PackageElement> pkgSet = this.classToPackage.get(te);
        if (pkgSet == null) {
            pkgSet = new TreeSet<Element>(this.utils.makeClassUseComparator());
            this.classToPackage.put(te, pkgSet);
        }
        return pkgSet;
    }

    private Set<TypeElement> classSet(TypeElement te) {
        Set<TypeElement> clsSet = this.classToClass.get(te);
        if (clsSet == null) {
            clsSet = new TreeSet<Element>(this.utils.makeClassUseComparator());
            this.classToClass.put(te, clsSet);
        }
        return clsSet;
    }

    private <T extends Element> void add(Map<TypeElement, List<T>> map, TypeElement te, T ref) {
        this.refList(map, te).add(ref);
        this.packageSet(te).add(this.elementUtils.getPackageOf(ref));
        TypeElement entry = this.utils.isField(ref) || this.utils.isConstructor(ref) || this.utils.isMethod(ref) ? (TypeElement)ref.getEnclosingElement() : (TypeElement)ref;
        this.classSet(te).add(entry);
    }

    private void addAll(Map<TypeElement, List<TypeElement>> map, TypeElement te, Collection<TypeElement> refs) {
        if (refs == null) {
            return;
        }
        this.refList(map, te).addAll(refs);
        Set<PackageElement> pkgSet = this.packageSet(te);
        Set<TypeElement> clsSet = this.classSet(te);
        for (TypeElement cls : refs) {
            pkgSet.add(this.utils.containingPackage(cls));
            clsSet.add(cls);
        }
    }

    private <T extends Element> void mapTypeParameters(final Map<TypeElement, List<T>> map, Element element, final T holder) {
        SimpleElementVisitor9<Void, Void> elementVisitor = new SimpleElementVisitor9<Void, Void>(){

            private void addParameters(TypeParameterElement e) {
                for (TypeMirror typeMirror : ClassUseMapper.this.utils.getBounds(e)) {
                    ClassUseMapper.this.addTypeParameterToMap(map, typeMirror, holder);
                }
            }

            @Override
            public Void visitType(TypeElement e, Void p) {
                for (TypeParameterElement typeParameterElement : e.getTypeParameters()) {
                    this.addParameters(typeParameterElement);
                }
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableElement e, Void p) {
                for (TypeParameterElement typeParameterElement : e.getTypeParameters()) {
                    this.addParameters(typeParameterElement);
                }
                return null;
            }

            @Override
            protected Void defaultAction(Element e, Void p) {
                ClassUseMapper.this.mapTypeParameters(map, e.asType(), holder);
                return null;
            }

            @Override
            public Void visitTypeParameter(TypeParameterElement e, Void p) {
                this.addParameters(e);
                return null;
            }
        };
        elementVisitor.visit(element);
    }

    private <T extends Element> void mapTypeParameters(final Map<TypeElement, List<T>> map, TypeMirror aType, final T holder) {
        SimpleTypeVisitor9<Void, Void> tv = new SimpleTypeVisitor9<Void, Void>(){

            @Override
            public Void visitWildcard(WildcardType t, Void p) {
                TypeMirror bound = t.getExtendsBound();
                if (bound != null) {
                    ClassUseMapper.this.addTypeParameterToMap(map, bound, holder);
                }
                if ((bound = t.getSuperBound()) != null) {
                    ClassUseMapper.this.addTypeParameterToMap(map, bound, holder);
                }
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, Void p) {
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    ClassUseMapper.this.addTypeParameterToMap(map, typeMirror, holder);
                }
                return null;
            }
        };
        tv.visit(aType);
    }

    private <T extends Element> void mapAnnotations(final Map<TypeElement, List<T>> map, Element e, final T holder) {
        new SimpleElementVisitor9<Void, Void>(){

            void addAnnotations(Element e) {
                for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                    ClassUseMapper.this.add(map, (TypeElement)annotationMirror.getAnnotationType().asElement(), holder);
                }
            }

            @Override
            public Void visitPackage(PackageElement e, Void p) {
                for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                    ClassUseMapper.this.refList(map, annotationMirror.getAnnotationType().asElement()).add(holder);
                }
                return null;
            }

            @Override
            protected Void defaultAction(Element e, Void p) {
                this.addAnnotations(e);
                return null;
            }
        }.visit(e);
    }

    private <T extends Element> void addTypeParameterToMap(final Map<TypeElement, List<T>> map, TypeMirror type, final T holder) {
        new SimpleTypeVisitor9<Void, Void>(){

            @Override
            protected Void defaultAction(TypeMirror e, Void p) {
                return (Void)super.defaultAction(e, p);
            }

            @Override
            public Void visitDeclared(DeclaredType t, Void p) {
                ClassUseMapper.this.add(map, (TypeElement)t.asElement(), holder);
                return null;
            }
        }.visit(type);
        this.mapTypeParameters(map, type, holder);
    }
}

