/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.main.JavaCompiler;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.GraphUtils;
import org.openjdk.tools.javac.util.Options;

public abstract class Dependencies {
    protected static final Context.Key<Dependencies> dependenciesKey = new Context.Key();

    public static Dependencies instance(Context context) {
        Dependencies instance = context.get(dependenciesKey);
        if (instance == null) {
            instance = new DummyDependencies(context);
        }
        return instance;
    }

    protected Dependencies(Context context) {
        context.put(dependenciesKey, this);
    }

    public abstract void push(Symbol.ClassSymbol var1, CompletionCause var2);

    public abstract void pop();

    private static class DummyDependencies
    extends Dependencies {
        private DummyDependencies(Context context) {
            super(context);
        }

        @Override
        public void push(Symbol.ClassSymbol s, CompletionCause phase) {
        }

        @Override
        public void pop() {
        }
    }

    public static class GraphDependencies
    extends Dependencies
    implements Closeable,
    Symbol.Completer {
        private EnumSet<DependenciesMode> dependenciesModes;
        private String dependenciesFile;
        Stack<Node> nodeStack = new Stack();
        Map<Symbol.ClassSymbol, Node> dependencyNodeMap = new LinkedHashMap<Symbol.ClassSymbol, Node>();

        public static void preRegister(Context context) {
            context.put(dependenciesKey, GraphDependencies::new);
        }

        GraphDependencies(Context context) {
            super(context);
            String[] modes;
            Options options = Options.instance(context);
            for (String mode : modes = options.get("completionDeps").split(",")) {
                if (!mode.startsWith("file=")) continue;
                this.dependenciesFile = mode.substring(5);
            }
            this.dependenciesModes = DependenciesMode.getDependenciesModes(modes);
            JavaCompiler compiler2 = JavaCompiler.instance(context);
            compiler2.closeables = compiler2.closeables.prepend(this);
        }

        @Override
        public void push(Symbol.ClassSymbol s, CompletionCause phase) {
            CompletionNode n = new CompletionNode(s);
            if (n == this.push(n, phase)) {
                s.completer = this;
            }
        }

        protected Node push(Node newNode, CompletionCause cc) {
            Node cachedNode = this.dependencyNodeMap.get(newNode.data);
            if (cachedNode == null) {
                this.dependencyNodeMap.put((Symbol.ClassSymbol)newNode.data, newNode);
            } else {
                newNode = cachedNode;
            }
            if (!this.nodeStack.isEmpty()) {
                Node currentNode = this.nodeStack.peek();
                currentNode.addDependency(cc, newNode);
            }
            this.nodeStack.push(newNode);
            return newNode;
        }

        @Override
        public void pop() {
            this.nodeStack.pop();
        }

        @Override
        public void close() throws IOException {
            if (!this.dependenciesModes.contains((Object)DependenciesMode.REDUNDANT)) {
                new PruneVisitor().visit(this.dependencyNodeMap.values(), null);
            }
            if (!this.dependenciesModes.contains((Object)DependenciesMode.CLASS)) {
                new FilterVisitor(CompletionNode.Kind.SOURCE).visit(this.dependencyNodeMap.values(), null);
            }
            if (!this.dependenciesModes.contains((Object)DependenciesMode.SOURCE)) {
                new FilterVisitor(CompletionNode.Kind.CLASS).visit(this.dependencyNodeMap.values(), null);
            }
            if (this.dependenciesFile != null) {
                try (FileWriter fw = new FileWriter(this.dependenciesFile);){
                    fw.append(GraphUtils.toDot(this.dependencyNodeMap.values(), "CompletionDeps", ""));
                }
            }
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            this.push((Symbol.ClassSymbol)sym, CompletionCause.OTHER);
            this.pop();
            sym.completer = this;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        public Collection<Node> getNodes() {
            return this.dependencyNodeMap.values();
        }

        private class FilterVisitor
        extends GraphUtils.NodeVisitor<Symbol.ClassSymbol, Node, Void> {
            CompletionNode.Kind ck;

            private FilterVisitor(CompletionNode.Kind ck) {
                this.ck = ck;
            }

            @Override
            public void visitNode(Node node, Void arg) {
                if (node instanceof CompletionNode && ((CompletionNode)node).ck != this.ck) {
                    GraphDependencies.this.dependencyNodeMap.remove(node.data);
                }
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dk, Node from, Node to, Void arg) {
                if (to instanceof CompletionNode && ((CompletionNode)to).ck != this.ck) {
                    from.depsByKind.get(dk).remove(to);
                }
            }
        }

        private static class PruneVisitor
        extends GraphUtils.NodeVisitor<Symbol.ClassSymbol, Node, Void> {
            private PruneVisitor() {
            }

            @Override
            public void visitNode(Node node, Void arg) {
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dk, Node from, Node to, Void arg) {
                if (from.equals(to)) {
                    to.depsByKind.get(dk).remove(from);
                }
            }
        }

        public static class CompletionNode
        extends Node {
            final Kind ck;

            CompletionNode(Symbol.ClassSymbol sym) {
                super(sym);
                boolean fromClass = sym.classfile == null && sym.sourcefile == null || sym.classfile != null && sym.classfile.getKind() == JavaFileObject.Kind.CLASS;
                this.ck = fromClass ? Kind.CLASS : Kind.SOURCE;
            }

            @Override
            public Properties nodeAttributes() {
                Properties p = super.nodeAttributes();
                p.put("style", this.ck.dotStyle);
                p.put("shape", "ellipse");
                return p;
            }

            public Symbol.ClassSymbol getClassSymbol() {
                return (Symbol.ClassSymbol)this.data;
            }

            static enum Kind {
                SOURCE("solid"),
                CLASS("dotted");

                final String dotStyle;

                private Kind(String dotStyle) {
                    this.dotStyle = dotStyle;
                }
            }
        }

        public static abstract class Node
        extends GraphUtils.AbstractNode<Symbol.ClassSymbol, Node>
        implements GraphUtils.DottableNode<Symbol.ClassSymbol, Node> {
            EnumMap<CompletionCause, List<Node>> depsByKind = new EnumMap(CompletionCause.class);

            Node(Symbol.ClassSymbol value) {
                super(value);
                for (CompletionCause depKind : CompletionCause.values()) {
                    this.depsByKind.put(depKind, new ArrayList());
                }
            }

            void addDependency(GraphUtils.DependencyKind depKind, Node dep) {
                List<Node> deps = this.depsByKind.get(depKind);
                if (!deps.contains(dep)) {
                    deps.add(dep);
                }
            }

            public boolean equals(Object obj) {
                return obj instanceof Node && ((Symbol.ClassSymbol)this.data).equals(((Node)obj).data);
            }

            public int hashCode() {
                return ((Symbol.ClassSymbol)this.data).hashCode();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return CompletionCause.values();
            }

            @Override
            public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dk) {
                return this.depsByKind.get(dk);
            }

            @Override
            public Properties nodeAttributes() {
                Properties p = new Properties();
                p.put("label", GraphUtils.DotVisitor.wrap(this.toString()));
                return p;
            }

            @Override
            public Properties dependencyAttributes(Node to, GraphUtils.DependencyKind dk) {
                Properties p = new Properties();
                p.put("label", dk);
                return p;
            }

            @Override
            public String toString() {
                return ((Symbol.ClassSymbol)this.data).getQualifiedName().toString();
            }
        }

        static enum DependenciesMode {
            SOURCE("source"),
            CLASS("class"),
            REDUNDANT("redundant");

            final String opt;

            private DependenciesMode(String opt) {
                this.opt = opt;
            }

            static EnumSet<DependenciesMode> getDependenciesModes(String[] modes) {
                EnumSet<DependenciesMode> res = EnumSet.noneOf(DependenciesMode.class);
                List<String> args = Arrays.asList(modes);
                if (args.contains("all")) {
                    res = EnumSet.allOf(DependenciesMode.class);
                }
                for (DependenciesMode mode : DependenciesMode.values()) {
                    if (args.contains(mode.opt)) {
                        res.add(mode);
                        continue;
                    }
                    if (!args.contains("-" + mode.opt)) continue;
                    res.remove((Object)mode);
                }
                return res;
            }
        }
    }

    public static enum CompletionCause implements GraphUtils.DependencyKind
    {
        CLASS_READER,
        HEADER_PHASE,
        HIERARCHY_PHASE,
        IMPORTS_PHASE,
        MEMBER_ENTER,
        MEMBERS_PHASE,
        OTHER;

    }
}

