/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckRegistry.class);
    private final ConcurrentMap<String, HealthCheck> healthChecks = new ConcurrentHashMap<String, HealthCheck>();

    public void register(String name, HealthCheck healthCheck) {
        this.healthChecks.putIfAbsent(name, healthCheck);
    }

    public void unregister(String name) {
        this.healthChecks.remove(name);
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.healthChecks.keySet()));
    }

    public HealthCheck.Result runHealthCheck(String name) throws NoSuchElementException {
        HealthCheck healthCheck = (HealthCheck)this.healthChecks.get(name);
        if (healthCheck == null) {
            throw new NoSuchElementException("No health check named " + name + " exists");
        }
        return healthCheck.execute();
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks() {
        TreeMap results = new TreeMap();
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            HealthCheck.Result result = ((HealthCheck)entry.getValue()).execute();
            results.put(entry.getKey(), result);
        }
        return Collections.unmodifiableSortedMap(results);
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks(ExecutorService executor) {
        HashMap futures = new HashMap();
        for (final Map.Entry entry : this.healthChecks.entrySet()) {
            futures.put(entry.getKey(), executor.submit(new Callable<HealthCheck.Result>(){

                @Override
                public HealthCheck.Result call() throws Exception {
                    return ((HealthCheck)entry.getValue()).execute();
                }
            }));
        }
        TreeMap results = new TreeMap();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                results.put(entry.getKey(), ((Future)entry.getValue()).get());
            }
            catch (Exception e) {
                LOGGER.warn("Error executing health check {}", entry.getKey(), (Object)e);
            }
        }
        return Collections.unmodifiableSortedMap(results);
    }
}

