/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.service;

import com.twitter.finagle.Address;
import com.twitter.finagle.Failure;
import com.twitter.finagle.Failure$Source$;
import com.twitter.finagle.HasRemoteInfo;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.client.Transporter$EndpointAddr$;
import com.twitter.finagle.context.RemoteInfo;
import com.twitter.finagle.context.RemoteInfo$Upstream$;
import com.twitter.finagle.param.Label;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.service.ExceptionRemoteInfoFactory;
import com.twitter.finagle.thrift.ClientId;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class ExceptionRemoteInfoFactory$ {
    public static final ExceptionRemoteInfoFactory$ MODULE$;
    private final Stack.Role role;

    static {
        new ExceptionRemoteInfoFactory$();
    }

    public Stack.Role role() {
        return this.role;
    }

    public <T> PartialFunction<Throwable, Future<T>> addRemoteInfo(SocketAddress endpointAddr, String label) {
        return new Serializable(endpointAddr, label){
            public static final long serialVersionUID = 0L;
            private final SocketAddress endpointAddr$1;
            private final String label$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof HasRemoteInfo) {
                    HasRemoteInfo hasRemoteInfo = (HasRemoteInfo)((Object)A1);
                    hasRemoteInfo.setRemoteInfo(new RemoteInfo.Available(RemoteInfo$Upstream$.MODULE$.addr(), ClientId$.MODULE$.current(), (Option<SocketAddress>)new Some((Object)this.endpointAddr$1), (Option<ClientId>)new Some((Object)new ClientId(this.label$1)), Trace$.MODULE$.id()));
                    object = Future$.MODULE$.exception((Throwable)((Object)hasRemoteInfo));
                } else if (A1 instanceof Failure) {
                    Failure failure = (Failure)A1;
                    object = Future$.MODULE$.exception((Throwable)failure.withSource(Failure$Source$.MODULE$.RemoteInfo(), new RemoteInfo.Available(RemoteInfo$Upstream$.MODULE$.addr(), ClientId$.MODULE$.current(), (Option<SocketAddress>)new Some((Object)this.endpointAddr$1), (Option<ClientId>)new Some((Object)new ClientId(this.label$1)), Trace$.MODULE$.id())));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HasRemoteInfo ? true : throwable instanceof Failure;
                return bl;
            }
            {
                this.endpointAddr$1 = endpointAddr$1;
                this.label$1 = label$1;
            }
        };
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> module() {
        return new Stack.ModuleParams<ServiceFactory<Req, Rep>>(){
            private final Stack.Role role;
            private final String description;
            private final Seq<Stack.Param<Transporter.EndpointAddr>> parameters;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public Seq<Stack.Param<Transporter.EndpointAddr>> parameters() {
                return this.parameters;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public ServiceFactory<Req, Rep> make(Stack.Params params, ServiceFactory<Req, Rep> next2) {
                String label;
                String string;
                Address endpointAddr = params.apply(Transporter$EndpointAddr$.MODULE$.param()).addr();
                Address address = endpointAddr;
                if (!(address instanceof Address.Inet)) return next2;
                Address.Inet inet = (Address.Inet)address;
                InetSocketAddress addr = inet.addr();
                Label label2 = params.apply(Label$.MODULE$.param());
                if (label2 == null) throw new MatchError((Object)label2);
                String label3 = string = (label = label2.label());
                return new ExceptionRemoteInfoFactory<Req, Rep>(next2, addr, label3);
            }
            {
                this.role = ExceptionRemoteInfoFactory$.MODULE$.role();
                this.description = "Add upstream/downstream addresses and trace id to request exceptions";
                this.parameters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stack.Param[]{(Stack.Param)Predef$.MODULE$.implicitly(Transporter$EndpointAddr$.MODULE$.param())}));
            }
        };
    }

    private ExceptionRemoteInfoFactory$() {
        MODULE$ = this;
        this.role = new Stack.Role("ExceptionRemoteInfo");
    }
}

