/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.util.concurrent.ListenableFuture;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.SpeculativeRequestExecutor;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadLastConfirmedAndEntryOp
implements BookkeeperInternalCallbacks.ReadEntryCallback,
SpeculativeRequestExecutor {
    static final Logger LOG = LoggerFactory.getLogger(ReadLastConfirmedAndEntryOp.class);
    private final ScheduledExecutorService scheduler;
    ReadLACAndEntryRequest request;
    final BitSet heardFromHostsBitSet;
    final BitSet emptyResponsesFromHostsBitSet;
    final int maxMissedReadsAllowed;
    boolean parallelRead = false;
    final AtomicBoolean requestComplete = new AtomicBoolean(false);
    final long requestTimeNano;
    private final LedgerHandle lh;
    private final LastConfirmedAndEntryCallback cb;
    private int numResponsesPending;
    private final int numEmptyResponsesAllowed;
    private volatile boolean hasValidResponse = false;
    private final long prevEntryId;
    private long lastAddConfirmed;
    private long timeOutInMillis;

    ReadLastConfirmedAndEntryOp(LedgerHandle lh, LastConfirmedAndEntryCallback cb, long prevEntryId, long timeOutInMillis, ScheduledExecutorService scheduler) {
        this.lh = lh;
        this.cb = cb;
        this.prevEntryId = prevEntryId;
        this.lastAddConfirmed = lh.getLastAddConfirmed();
        this.timeOutInMillis = timeOutInMillis;
        this.numResponsesPending = 0;
        this.numEmptyResponsesAllowed = this.getLedgerMetadata().getWriteQuorumSize() - this.getLedgerMetadata().getAckQuorumSize() + 1;
        this.requestTimeNano = MathUtils.nowInNano();
        this.scheduler = scheduler;
        this.maxMissedReadsAllowed = this.getLedgerMetadata().getEnsembleSize() - this.getLedgerMetadata().getAckQuorumSize();
        this.heardFromHostsBitSet = new BitSet(this.getLedgerMetadata().getEnsembleSize());
        this.emptyResponsesFromHostsBitSet = new BitSet(this.getLedgerMetadata().getEnsembleSize());
    }

    protected LedgerMetadata getLedgerMetadata() {
        return this.lh.metadata;
    }

    ReadLastConfirmedAndEntryOp parallelRead(boolean enabled) {
        this.parallelRead = enabled;
        return this;
    }

    @Override
    public ListenableFuture<Boolean> issueSpeculativeRequest() {
        return this.lh.bk.mainWorkerPool.submitOrdered((Object)this.lh.getId(), new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!ReadLastConfirmedAndEntryOp.this.requestComplete.get() && !ReadLastConfirmedAndEntryOp.this.request.isComplete() && null != ReadLastConfirmedAndEntryOp.this.request.maybeSendSpeculativeRead(ReadLastConfirmedAndEntryOp.this.heardFromHostsBitSet)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Send speculative ReadLAC {} for ledger {} (previousLAC: {}). Hosts heard are {}.", new Object[]{ReadLastConfirmedAndEntryOp.this.request, ReadLastConfirmedAndEntryOp.this.lh.getId(), ReadLastConfirmedAndEntryOp.this.lastAddConfirmed, ReadLastConfirmedAndEntryOp.this.heardFromHostsBitSet});
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void initiate() {
        this.request = this.parallelRead ? new ParallelReadRequest(this.lh.metadata.currentEnsemble, this.lh.ledgerId, this.prevEntryId + 1L) : new SequenceReadRequest(this.lh.metadata.currentEnsemble, this.lh.ledgerId, this.prevEntryId + 1L);
        this.request.read();
        if (!this.parallelRead && this.lh.bk.getReadLACSpeculativeRequestPolicy().isPresent()) {
            this.lh.bk.getReadLACSpeculativeRequestPolicy().get().initiateSpeculativeRequest(this.scheduler, this);
        }
    }

    void sendReadTo(int bookieIndex, BookieSocketAddress to, ReadLACAndEntryRequest entry) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Calling Read LAC and Entry with {} and long polling interval {} on Bookie {} - Parallel {}", new Object[]{this.prevEntryId, this.timeOutInMillis, to, this.parallelRead});
        }
        this.lh.bk.bookieClient.readEntryWaitForLACUpdate(to, this.lh.ledgerId, -1L, this.prevEntryId, this.timeOutInMillis, true, this, new ReadLastConfirmedAndEntryContext(bookieIndex, to));
        ++this.numResponsesPending;
    }

    private void submitCallback(int rc, long lastAddConfirmed, LedgerEntry entry) {
        long latencyMicros = MathUtils.elapsedMicroSec(this.requestTimeNano);
        if (0 != rc) {
            this.lh.bk.getReadLacAndEntryOpLogger().registerFailedEvent(latencyMicros, TimeUnit.MICROSECONDS);
        } else {
            this.lh.bk.getReadLacAndEntryOpLogger().registerSuccessfulEvent(latencyMicros, TimeUnit.MICROSECONDS);
        }
        this.cb.readLastConfirmedAndEntryComplete(rc, lastAddConfirmed, entry);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
        block14: {
            BookieSocketAddress bookie;
            ReadLastConfirmedAndEntryContext rCtx;
            block13: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} received response for (lid={}, eid={}) : {}", new Object[]{this.getClass().getName(), ledgerId, entryId, rc});
                }
                rCtx = (ReadLastConfirmedAndEntryContext)ctx;
                bookie = rCtx.getBookieAddress();
                --this.numResponsesPending;
                if (0 != rc) break block13;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received lastAddConfirmed (lac={}) from bookie({}) for (lid={}).", new Object[]{rCtx.getLastAddConfirmed(), bookie, ledgerId});
                }
                if (rCtx.getLastAddConfirmed() > this.lastAddConfirmed) {
                    this.lastAddConfirmed = rCtx.getLastAddConfirmed();
                    this.lh.updateLastConfirmed(rCtx.getLastAddConfirmed(), 0L);
                }
                this.hasValidResponse = true;
                if (entryId != -1L) {
                    if (this.request.complete(rCtx.getBookieIndex(), bookie, buffer, entryId)) {
                        if (rCtx.getLacUpdateTimestamp().isPresent()) {
                            long elapsedMicros = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis() - rCtx.getLacUpdateTimestamp().get());
                            elapsedMicros = Math.max(elapsedMicros, 0L);
                            this.lh.bk.getReadLacAndEntryRespLogger().registerSuccessfulEvent(elapsedMicros, TimeUnit.MICROSECONDS);
                        }
                        this.submitCallback(0, this.lastAddConfirmed, this.request);
                        this.requestComplete.set(true);
                        this.heardFromHostsBitSet.set(rCtx.getBookieIndex(), true);
                    }
                    break block14;
                } else {
                    this.emptyResponsesFromHostsBitSet.set(rCtx.getBookieIndex(), true);
                    if (this.lastAddConfirmed > this.prevEntryId) {
                        this.completeRequest();
                        return;
                    }
                    if (this.emptyResponsesFromHostsBitSet.cardinality() >= this.numEmptyResponsesAllowed) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Completed readLACAndEntry(lid = {}, previousEntryId = {}) after received {} empty responses ('{}').", new Object[]{ledgerId, this.prevEntryId, this.emptyResponsesFromHostsBitSet.cardinality(), this.emptyResponsesFromHostsBitSet});
                        }
                        this.completeRequest();
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received empty response for readLACAndEntry(lid = {}, previousEntryId = {}) from bookie {} @ {}, reattempting reading next bookie : lac = {}", new Object[]{ledgerId, this.prevEntryId, rCtx.getBookieAddress(), rCtx.getBookieAddress(), this.lastAddConfirmed});
                    }
                    this.request.logErrorAndReattemptRead(rCtx.getBookieIndex(), bookie, "Empty Response", rc);
                    return;
                }
            }
            if (-102 == rc && !this.requestComplete.get()) {
                this.submitCallback(rc, this.lastAddConfirmed, null);
                this.requestComplete.set(true);
            } else {
                this.request.logErrorAndReattemptRead(rCtx.getBookieIndex(), bookie, "Error: " + BKException.getMessage(rc), rc);
                return;
            }
        }
        if (this.numResponsesPending > 0) return;
        this.completeRequest();
    }

    private void completeRequest() {
        if (this.requestComplete.compareAndSet(false, true)) {
            if (!this.hasValidResponse) {
                this.submitCallback(this.request.getFirstError(), this.lastAddConfirmed, null);
            } else {
                this.submitCallback(0, this.lastAddConfirmed, null);
            }
        }
    }

    public String toString() {
        return String.format("ReadLastConfirmedAndEntryOp(lid=%d, prevEntryId=%d])", this.lh.ledgerId, this.prevEntryId);
    }

    static interface LastConfirmedAndEntryCallback {
        public void readLastConfirmedAndEntryComplete(int var1, long var2, LedgerEntry var4);
    }

    class SequenceReadRequest
    extends ReadLACAndEntryRequest {
        static final int NOT_FOUND = -1;
        int nextReplicaIndexToReadFrom;
        final BitSet sentReplicas;
        final BitSet erroredReplicas;
        final BitSet emptyResponseReplicas;

        SequenceReadRequest(ArrayList<BookieSocketAddress> ensemble, long lId, long eId) {
            super(ensemble, lId, eId);
            this.nextReplicaIndexToReadFrom = 0;
            this.sentReplicas = new BitSet(this.orderedEnsemble.size());
            this.erroredReplicas = new BitSet(this.orderedEnsemble.size());
            this.emptyResponseReplicas = new BitSet(this.orderedEnsemble.size());
        }

        private synchronized int getNextReplicaIndexToReadFrom() {
            return this.nextReplicaIndexToReadFrom;
        }

        private int getReplicaIndex(int bookieIndex) {
            return this.orderedEnsemble.indexOf(bookieIndex);
        }

        private BitSet getSentToBitSet() {
            BitSet b = new BitSet(this.ensemble.size());
            for (int i = 0; i < this.sentReplicas.length(); ++i) {
                if (!this.sentReplicas.get(i)) continue;
                b.set((Integer)this.orderedEnsemble.get(i));
            }
            return b;
        }

        private boolean readsOutstanding() {
            return this.sentReplicas.cardinality() - this.erroredReplicas.cardinality() - this.emptyResponseReplicas.cardinality() > 0;
        }

        @Override
        synchronized BookieSocketAddress maybeSendSpeculativeRead(BitSet heardFrom) {
            if (this.nextReplicaIndexToReadFrom >= ReadLastConfirmedAndEntryOp.this.getLedgerMetadata().getEnsembleSize()) {
                return null;
            }
            BitSet sentTo = this.getSentToBitSet();
            sentTo.and(heardFrom);
            if (sentTo.cardinality() == 0) {
                return this.sendNextRead();
            }
            return null;
        }

        @Override
        void read() {
            this.sendNextRead();
        }

        synchronized BookieSocketAddress sendNextRead() {
            if (this.nextReplicaIndexToReadFrom >= ReadLastConfirmedAndEntryOp.this.getLedgerMetadata().getEnsembleSize()) {
                if (-8 == this.firstError && this.numMissedEntryReads > ReadLastConfirmedAndEntryOp.this.maxMissedReadsAllowed) {
                    this.firstError = -13;
                }
                this.fail(this.firstError);
                return null;
            }
            int replica = this.nextReplicaIndexToReadFrom;
            int bookieIndex = (Integer)this.orderedEnsemble.get(this.nextReplicaIndexToReadFrom);
            ++this.nextReplicaIndexToReadFrom;
            try {
                BookieSocketAddress to = (BookieSocketAddress)this.ensemble.get(bookieIndex);
                ReadLastConfirmedAndEntryOp.this.sendReadTo(bookieIndex, to, this);
                this.sentReplicas.set(replica);
                return to;
            }
            catch (InterruptedException ie) {
                LOG.error("Interrupted reading entry " + this, (Throwable)ie);
                Thread.currentThread().interrupt();
                this.fail(-15);
                return null;
            }
        }

        @Override
        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieSocketAddress host, String errMsg, int rc) {
            super.logErrorAndReattemptRead(bookieIndex, host, errMsg, rc);
            int replica = this.getReplicaIndex(bookieIndex);
            if (replica == -1) {
                LOG.error("Received error from a host which is not in the ensemble {} {}.", (Object)host, (Object)this.ensemble);
                return;
            }
            if (0 == rc) {
                this.emptyResponseReplicas.set(replica);
            } else {
                this.erroredReplicas.set(replica);
            }
            if (!this.readsOutstanding()) {
                this.sendNextRead();
            }
        }
    }

    class ParallelReadRequest
    extends ReadLACAndEntryRequest {
        int numPendings;

        ParallelReadRequest(ArrayList<BookieSocketAddress> ensemble, long lId, long eId) {
            super(ensemble, lId, eId);
            this.numPendings = this.orderedEnsemble.size();
        }

        @Override
        void read() {
            Iterator iterator = this.orderedEnsemble.iterator();
            while (iterator.hasNext()) {
                int bookieIndex = (Integer)iterator.next();
                BookieSocketAddress to = (BookieSocketAddress)this.ensemble.get(bookieIndex);
                try {
                    ReadLastConfirmedAndEntryOp.this.sendReadTo(bookieIndex, to, this);
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted reading entry {} : ", (Object)this, (Object)ie);
                    Thread.currentThread().interrupt();
                    this.fail(-15);
                    return;
                }
            }
        }

        @Override
        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieSocketAddress host, String errMsg, int rc) {
            super.logErrorAndReattemptRead(bookieIndex, host, errMsg, rc);
            --this.numPendings;
            if (this.numMissedEntryReads > ReadLastConfirmedAndEntryOp.this.maxMissedReadsAllowed || this.numPendings == 0) {
                if (-8 == this.firstError && this.numMissedEntryReads > ReadLastConfirmedAndEntryOp.this.maxMissedReadsAllowed) {
                    this.firstError = -13;
                }
                this.fail(this.firstError);
            }
        }

        @Override
        BookieSocketAddress maybeSendSpeculativeRead(BitSet heardFromHostsBitSet) {
            return null;
        }
    }

    abstract class ReadLACAndEntryRequest
    extends LedgerEntry {
        final AtomicBoolean complete;
        int rc;
        int firstError;
        int numMissedEntryReads;
        final ArrayList<BookieSocketAddress> ensemble;
        final List<Integer> writeSet;
        final List<Integer> orderedEnsemble;

        ReadLACAndEntryRequest(ArrayList<BookieSocketAddress> ensemble, long lId, long eId) {
            super(lId, eId);
            this.complete = new AtomicBoolean(false);
            this.rc = 0;
            this.firstError = 0;
            this.numMissedEntryReads = 0;
            this.ensemble = ensemble;
            this.writeSet = ((ReadLastConfirmedAndEntryOp)ReadLastConfirmedAndEntryOp.this).lh.distributionSchedule.getWriteSet(this.entryId);
            this.orderedEnsemble = ((ReadLastConfirmedAndEntryOp)ReadLastConfirmedAndEntryOp.this).lh.bk.reorderReadSequence ? ((ReadLastConfirmedAndEntryOp)ReadLastConfirmedAndEntryOp.this).lh.bk.placementPolicy.reorderReadLACSequence(ensemble, this.writeSet, ((ReadLastConfirmedAndEntryOp)ReadLastConfirmedAndEntryOp.this).lh.bookieFailureHistory.asMap()) : this.writeSet;
        }

        synchronized int getFirstError() {
            return this.firstError;
        }

        abstract void read();

        boolean complete(int bookieIndex, BookieSocketAddress host, ByteBuf buffer, long entryId) {
            ByteBuf content;
            try {
                content = ((ReadLastConfirmedAndEntryOp)ReadLastConfirmedAndEntryOp.this).lh.macManager.verifyDigestAndReturnData(entryId, buffer);
            }
            catch (BKException.BKDigestMatchException e) {
                this.logErrorAndReattemptRead(bookieIndex, host, "Mac mismatch", -5);
                buffer.release();
                return false;
            }
            if (!this.complete.getAndSet(true)) {
                this.rc = 0;
                this.entryId = entryId;
                this.length = buffer.getLong(24);
                this.data = content;
                return true;
            }
            return false;
        }

        boolean fail(int rc) {
            if (this.complete.compareAndSet(false, true)) {
                this.rc = rc;
                this.translateAndSetFirstError(rc);
                ReadLastConfirmedAndEntryOp.this.completeRequest();
                return true;
            }
            return false;
        }

        private synchronized void translateAndSetFirstError(int rc) {
            if (0 == this.firstError || -13 == this.firstError || -7 == this.firstError) {
                this.firstError = rc;
            } else if (-8 == this.firstError && -13 != rc && -7 != rc) {
                this.firstError = rc;
            }
        }

        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieSocketAddress host, String errMsg, int rc) {
            this.translateAndSetFirstError(rc);
            if (-13 == rc || -7 == rc) {
                if (this.writeSet.contains(bookieIndex)) {
                    ReadLastConfirmedAndEntryOp.this.lh.registerOperationFailureOnBookie(host, this.entryId);
                }
                ++this.numMissedEntryReads;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(errMsg + " while reading entry: " + this.entryId + " ledgerId: " + ((ReadLastConfirmedAndEntryOp)ReadLastConfirmedAndEntryOp.this).lh.ledgerId + " from bookie: " + host);
            }
        }

        abstract BookieSocketAddress maybeSendSpeculativeRead(BitSet var1);

        boolean isComplete() {
            return this.complete.get();
        }

        int getRc() {
            return this.rc;
        }

        public String toString() {
            return String.format("L%d-E%d", this.ledgerId, this.entryId);
        }
    }
}

