/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.concurrent;

import com.twitter.concurrent.Tx;
import com.twitter.concurrent.Tx$;
import com.twitter.concurrent.Tx$Abort$;
import com.twitter.util.Future;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class Txs {
    public static final Tx<BoxedUnit> UNIT = Txs.newConstTx(BoxedUnit.UNIT);
    public static final Tx<?> ABORTED = Tx$.MODULE$.aborted();

    private Txs() {
    }

    public static <T> Tx<T> newTx(T t) {
        return Tx$.MODULE$.apply(t);
    }

    public static <T> Tx<T> newConstTx(final T t) {
        return new Tx<T>(){

            @Override
            public Future<Tx.Result<T>> ack() {
                Tx.Commit<Object> commit = new Tx.Commit<Object>(t);
                return Future.value(commit);
            }

            @Override
            public void nack() {
            }
        };
    }

    public static <T> Tx<T> newAbortedTx() {
        return Txs.newTx(null);
    }

    public static <T> Tuple2<Tx<BoxedUnit>, Tx<T>> twoParty(T t) {
        return Tx$.MODULE$.twoParty(t);
    }

    public static boolean isCommitted(Tx.Result<?> result2) {
        return result2 instanceof Tx.Commit;
    }

    public static boolean isAborted(Tx.Result<?> result2) {
        return result2 instanceof Tx$Abort$;
    }

    public static <T> T sample(Tx.Result<T> result2) {
        if (Txs.isCommitted(result2)) {
            return ((Tx.Commit)result2).value();
        }
        throw new IllegalArgumentException("Given result is not committed.");
    }
}

