/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.base.Optional;
import com.twitter.finagle.stats.NullStatsReceiver;
import com.twitter.finagle.stats.NullStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import java.io.IOException;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.distributedlog.service.MonitorService;
import org.apache.distributedlog.util.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorServiceApp {
    private static final Logger logger = LoggerFactory.getLogger(MonitorServiceApp.class);
    static final String USAGE = "MonitorService [-u <uri>] [-c <conf>] [-s serverset]";
    final String[] args;
    final Options options = new Options();

    private MonitorServiceApp(String[] args) {
        this.args = args;
        this.options.addOption("u", "uri", true, "DistributedLog URI");
        this.options.addOption("c", "conf", true, "DistributedLog Configuration File");
        this.options.addOption("s", "serverset", true, "Proxy Server Set");
        this.options.addOption("i", "interval", true, "Check interval");
        this.options.addOption("d", "region", true, "Region ID");
        this.options.addOption("p", "provider", true, "DistributedLog Stats Provider");
        this.options.addOption("f", "filter", true, "Filter streams by regex");
        this.options.addOption("w", "watch", false, "Watch stream changes under a given namespace");
        this.options.addOption("n", "instance_id", true, "Instance ID");
        this.options.addOption("t", "total_instances", true, "Total instances");
        this.options.addOption("hck", "heartbeat-num-checks", true, "Send a heartbeat after num checks");
        this.options.addOption("hsci", "handshake-with-client-info", false, "Enable handshaking with client info");
    }

    void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(USAGE, this.options);
    }

    private void run() {
        try {
            logger.info("Running monitor service.");
            BasicParser parser = new BasicParser();
            CommandLine cmdline = parser.parse(this.options, this.args);
            this.runCmd(cmdline);
        }
        catch (ParseException pe) {
            this.printUsage();
            Runtime.getRuntime().exit(-1);
        }
        catch (IOException ie) {
            logger.error("Failed to start monitor service : ", (Throwable)ie);
            Runtime.getRuntime().exit(-1);
        }
    }

    void runCmd(CommandLine cmdline) throws IOException {
        NullStatsProvider statsProvider = new NullStatsProvider();
        if (cmdline.hasOption("p")) {
            String providerClass = cmdline.getOptionValue("p");
            statsProvider = (StatsProvider)ReflectionUtils.newInstance((String)providerClass, StatsProvider.class);
        }
        NullStatsReceiver$ statsReceiver = NullStatsReceiver.get();
        final MonitorService monitorService = new MonitorService((Optional<String>)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"u"), (Optional<String>)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"c"), (Optional<String>)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"s"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"i"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"d"), (Optional<String>)CommandLineUtils.getOptionalStringArg((CommandLine)cmdline, (String)"f"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"n"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"t"), (Optional<Integer>)CommandLineUtils.getOptionalIntegerArg((CommandLine)cmdline, (String)"hck"), (Optional<Boolean>)CommandLineUtils.getOptionalBooleanArg((CommandLine)cmdline, (String)"hsci"), (Optional<Boolean>)CommandLineUtils.getOptionalBooleanArg((CommandLine)cmdline, (String)"w"), (Optional<Boolean>)CommandLineUtils.getOptionalBooleanArg((CommandLine)cmdline, (String)"mx"), (StatsReceiver)statsReceiver, (StatsProvider)statsProvider);
        monitorService.runServer();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Closing monitor service.");
                monitorService.close();
                logger.info("Closed monitor service.");
            }
        });
        try {
            monitorService.join();
        }
        catch (InterruptedException ie) {
            logger.warn("Interrupted when waiting monitor service to be finished : ", (Throwable)ie);
        }
    }

    public static void main(String[] args) {
        MonitorServiceApp launcher = new MonitorServiceApp(args);
        launcher.run();
    }
}

