/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.servlets.AdminServlet;
import java.util.EventListener;
import javax.servlet.Servlet;
import org.apache.bookkeeper.stats.HealthCheckServletContextListener;
import org.apache.bookkeeper.stats.MetricsServletContextListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ServletReporter {
    private final MetricRegistry metricRegistry;
    private final HealthCheckRegistry healthCheckRegistry;
    private final int port;
    private final Server jettyServer;

    public ServletReporter(MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry, int port) {
        this.metricRegistry = metricRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
        this.port = port;
        this.jettyServer = new Server(port);
    }

    public void start() throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.jettyServer.setHandler((Handler)context);
        context.addEventListener((EventListener)((Object)new HealthCheckServletContextListener(this.healthCheckRegistry)));
        context.addEventListener((EventListener)((Object)new MetricsServletContextListener(this.metricRegistry)));
        context.addServlet(new ServletHolder((Servlet)new AdminServlet()), "/*");
        this.jettyServer.start();
    }

    public void stop() throws Exception {
        this.jettyServer.stop();
    }
}

