/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation;

import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public enum RequestMethod {
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    OPTIONS,
    TRACE;


    @Nullable
    public static RequestMethod resolve(String method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        return switch (method) {
            case "GET" -> GET;
            case "HEAD" -> HEAD;
            case "POST" -> POST;
            case "PUT" -> PUT;
            case "PATCH" -> PATCH;
            case "DELETE" -> DELETE;
            case "OPTIONS" -> OPTIONS;
            case "TRACE" -> TRACE;
            default -> null;
        };
    }

    @Nullable
    public static RequestMethod resolve(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"HttpMethod must not be null");
        return RequestMethod.resolve(httpMethod.name());
    }

    public HttpMethod asHttpMethod() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GET -> HttpMethod.GET;
            case HEAD -> HttpMethod.HEAD;
            case POST -> HttpMethod.POST;
            case PUT -> HttpMethod.PUT;
            case PATCH -> HttpMethod.PATCH;
            case DELETE -> HttpMethod.DELETE;
            case OPTIONS -> HttpMethod.OPTIONS;
            case TRACE -> HttpMethod.TRACE;
        };
    }
}

