/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.nativo.jlibaio;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.nativo.jlibaio.SubmitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibaioFile<Callback extends SubmitInfo>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LibaioFile.class);
    protected boolean open;
    final LibaioContext<Callback> ctx;
    private int fd;

    LibaioFile(int fd, LibaioContext ctx) {
        this.ctx = ctx;
        this.fd = fd;
    }

    public int getBlockSize() {
        return LibaioContext.getBlockSizeFD(this.fd);
    }

    public boolean lock() {
        return LibaioContext.lock(this.fd);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        LibaioContext.close(this.fd);
    }

    public long getSize() {
        return LibaioContext.getSize(this.fd);
    }

    public void write(long position, int size, ByteBuffer buffer, Callback callback) throws IOException {
        this.ctx.submitWrite(this.fd, position, size, buffer, callback);
    }

    public void read(long position, int size, ByteBuffer buffer, Callback callback) throws IOException {
        this.ctx.submitRead(this.fd, position, size, buffer, callback);
    }

    public ByteBuffer newBuffer(int size) {
        return LibaioContext.newAlignedBuffer(size, 4096);
    }

    public void fill(int alignment, long size) {
        try {
            LibaioContext.fill(this.fd, alignment, size);
        }
        catch (OutOfMemoryError e) {
            logger.warn("Did not have enough memory to allocate " + size + " bytes in memory while filling the file, using simple fallocate");
            LibaioContext.fallocate(this.fd, size);
        }
    }

    public void fallocate(long size) {
        LibaioContext.fallocate(this.fd, size);
    }
}

