/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class JsonDataFormatReifier
extends DataFormatReifier<JsonDataFormat> {
    public JsonDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (JsonDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        properties.put("objectMapper", this.asRef(((JsonDataFormat)this.definition).getObjectMapper()));
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Jackson) {
            if (((JsonDataFormat)this.definition).getUseDefaultObjectMapper() == null) {
                properties.put("useDefaultObjectMapper", "true");
            } else {
                properties.put("useDefaultObjectMapper", ((JsonDataFormat)this.definition).getUseDefaultObjectMapper());
            }
            properties.put("autoDiscoverObjectMapper", ((JsonDataFormat)this.definition).getAutoDiscoverObjectMapper());
            properties.put("jsonView", this.or(((JsonDataFormat)this.definition).getJsonView(), ((JsonDataFormat)this.definition).getJsonViewTypeName()));
        } else {
            properties.put("jsonView", ((JsonDataFormat)this.definition).getJsonView());
        }
        properties.put("unmarshalType", this.or(((JsonDataFormat)this.definition).getUnmarshalType(), ((JsonDataFormat)this.definition).getUnmarshalTypeName()));
        properties.put("prettyPrint", ((JsonDataFormat)this.definition).getPrettyPrint());
        properties.put("include", ((JsonDataFormat)this.definition).getInclude());
        properties.put("allowJmsType", ((JsonDataFormat)this.definition).getAllowJmsType());
        properties.put("collectionType", this.or(((JsonDataFormat)this.definition).getCollectionType(), ((JsonDataFormat)this.definition).getCollectionTypeName()));
        properties.put("useList", ((JsonDataFormat)this.definition).getUseList());
        properties.put("combineUnicodeSurrogates", ((JsonDataFormat)this.definition).getCombineUnicodeSurrogates());
        properties.put("moduleClassNames", ((JsonDataFormat)this.definition).getModuleClassNames());
        properties.put("moduleRefs", ((JsonDataFormat)this.definition).getModuleRefs());
        properties.put("enableFeatures", ((JsonDataFormat)this.definition).getEnableFeatures());
        properties.put("disableFeatures", ((JsonDataFormat)this.definition).getDisableFeatures());
        properties.put("allowUnmarshallType", ((JsonDataFormat)this.definition).getAllowUnmarshallType());
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Jackson) {
            properties.put("schemaResolver", this.asRef(((JsonDataFormat)this.definition).getSchemaResolver()));
            properties.put("autoDiscoverSchemaResolver", ((JsonDataFormat)this.definition).getAutoDiscoverSchemaResolver());
            properties.put("namingStrategy", ((JsonDataFormat)this.definition).getNamingStrategy());
            properties.put("timezone", ((JsonDataFormat)this.definition).getTimezone());
        }
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Fastjson || ((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Gson) {
            properties.put("dateFormatPattern", ((JsonDataFormat)this.definition).getDateFormatPattern());
        }
    }
}

